/*************************************************************************
 *    CompuCell - A software framework for multimodel simulations of     *
 * biocomplexity problems Copyright (C) 2003 University of Notre Dame,   *
 *                             Indiana                                   *
 *                                                                       *
 * This program is free software; IF YOU AGREE TO CITE USE OF CompuCell  *
 *  IN ALL RELATED RESEARCH PUBLICATIONS according to the terms of the   *
 *  CompuCell GNU General Public License RIDER you can redistribute it   *
 * and/or modify it under the terms of the GNU General Public License as *
 *  published by the Free Software Foundation; either version 2 of the   *
 *         License, or (at your option) any later version.               *
 *                                                                       *
 * This program is distributed in the hope that it will be useful, but   *
 *      WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    *
 *             General Public License for more details.                  *
 *                                                                       *
 *  You should have received a copy of the GNU General Public License    *
 *     along with this program; if not, write to the Free Software       *
 *      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.        *
 *************************************************************************/

#include <CompuCell3D/ClassRegistry.h>

using namespace CompuCell3D;

#include <CompuCell3D/Simulator.h>
#include <CompuCell3D/Potts3D/Potts3D.h>


#include <BasicUtils/BasicString.h>
#include <BasicUtils/BasicException.h>

using namespace CompuCell3D;


#include <CompuCell3D/Potts3D/CellInventory.h>

#include <iostream>
using namespace std;


#include "SwitchTipStalkSteppable.h"

SwitchTipStalkSteppable::SwitchTipStalkSteppable() {
	
}
SwitchTipStalkSteppable::~SwitchTipStalkSteppable() {}


void SwitchTipStalkSteppable::init(Simulator *simulator, CC3DXMLElement *_xmlData) {
    //cerr << "INITIALIZE SwitchTipStalkSteppable"<<endl;
  xmlData=_xmlData;
  
  potts = simulator->getPotts();
  cellInventoryPtr=& potts->getCellInventory();
  automaton = potts->getAutomaton();
  fieldG = (WatchableField3D<CellG *> *)potts->getCellFieldG();

  simulator->registerSteerableObject(this);
    
     // define a new data-class (clusterData) for each cell:	
//     BasicClassAccessorBase * clusterDataAccessorPtr=&clusterDataAccessor;
// 	potts->getCellFactoryGroupPtr()->registerClass(clusterDataAccessorPtr); //this is to register the BasicclassAccessor to the large factory file
    
    bool clusterDataTrackerAlreadyRegisteredFlag;
	clusterDataTrackerPlugin=(ClusterDataTrackerPlugin*)Simulator::pluginManager.get("ClusterDataTrackerPlugin",&clusterDataTrackerAlreadyRegisteredFlag);
	if (!clusterDataTrackerAlreadyRegisteredFlag){
		clusterDataTrackerPlugin->init(simulator,_xmlData);
	}
        

        
    
    //rand function for probobality funtion, is class
    rand = BasicRandomNumberGenerator::getInstance();

    update(xmlData);
}

void SwitchTipStalkSteppable::extraInit(Simulator *simulator){
    //PUT YOUR CODE HERE
  //FPDGFB = simulator->getConcentrationFieldByName("PDGFB");
  //FLTGFb = simulator->getConcentrationFieldByName("LTGFb"); 
  //FTGFb = simulator->getConcentrationFieldByName("TGFb"); 
  //FuPAR = simulator->getConcentrationFieldByName("uPAR");
  //FuPA = simulator->getConcentrationFieldByName("uPA");
  //FuPARact = simulator->getConcentrationFieldByName("uPARact");
}

void SwitchTipStalkSteppable::start(){
    if (createHaploid)
        {
        CellInventory::cellInventoryIterator cii;
        for (cii=cellInventoryPtr->cellInventoryBegin(); cii!=cellInventoryPtr->cellInventoryEnd(); ++cii)
            { 
            CellG *cell;
            cell=cellInventoryPtr->getCell(cii);
            
            long int ownClusterId=cell->clusterId;
            if(clusterDataTrackerPlugin->getIfEC(ownClusterId))
                {
                double randomP= rand->getRatio();
        
                if (randomP < haploidPercentage)   
                    cell->type=automaton->getTypeId("haplocell");
                }
            }
        }
}
void SwitchTipStalkSteppable::step(const unsigned int currentStep){
    if (switchStalkTipFate)
        {
        CellInventory::cellInventoryIterator cii;
        for (cii=cellInventoryPtr->cellInventoryBegin(); cii!=cellInventoryPtr->cellInventoryEnd(); ++cii)
            { 
            CellG *cell;
            cell=cellInventoryPtr->getCell(cii);
            
            long int ownClusterId=cell->clusterId;
            if(clusterDataTrackerPlugin->getIfEC(ownClusterId))
                {
                //cerr<<"switchStalkTipFateNICDconc="<<switchStalkTipFateNICDconc<<endl;
                double NICDconc=clusterDataTrackerPlugin->getReporterConcentration(ownClusterId);
                if ((NICDconc<switchStalkTipFateNICDconc)&& (cell->type==automaton->getTypeId("cell")))
                    cell->type=automaton->getTypeId("tipcell");
                else if ((NICDconc>switchStalkTipFateNICDconc)&& (cell->type==automaton->getTypeId("tipcell")))
                    cell->type=automaton->getTypeId("cell");
                else if ((NICDconc<switchStalkTipFateNICDconc)&& (cell->type==automaton->getTypeId("haplocell")))
                    cell->type=automaton->getTypeId("haplotipcell");
                else if ((NICDconc>switchStalkTipFateNICDconc)&& (cell->type==automaton->getTypeId("haplotipcell")))
                    cell->type=automaton->getTypeId("haplocell");
                }
            }
        }

}







void SwitchTipStalkSteppable::update(CC3DXMLElement *_xmlData){
    boundaryStrategy=BoundaryStrategy::getInstance();
    //cerr<<"got here will do neighbor order"<<endl;
    if(_xmlData->getFirstElement("NeighborOrder"))
        maxNeighborIndex=boundaryStrategy->getMaxNeighborIndexFromNeighborOrder(_xmlData->getFirstElement("NeighborOrder")->getUInt());	
    else
        maxNeighborIndex=boundaryStrategy->getMaxNeighborIndexFromNeighborOrder(2);
    
    
    if(_xmlData->getFirstElement("createHaploid"))
        createHaploid=_xmlData->getFirstElement("createHaploid")->getDouble();	
    else
        createHaploid=0.0;
    
    if(_xmlData->getFirstElement("haploidPercentage"))
        haploidPercentage=_xmlData->getFirstElement("haploidPercentage")->getDouble();	
    else
        haploidPercentage=0.5;
    
    if(_xmlData->getFirstElement("switchStalkTipFate"))
        switchStalkTipFate=_xmlData->getFirstElement("switchStalkTipFate")->getDouble();	
    else
        switchStalkTipFate=0.0;
    
    if(_xmlData->getFirstElement("switchStalkTipFateNICDconc"))
        switchStalkTipFateNICDconc=_xmlData->getFirstElement("switchStalkTipFateNICDconc")->getDouble();	
    else
        switchStalkTipFateNICDconc=150.0;
    
}

std::string SwitchTipStalkSteppable::toString(){
   return "SwitchTipStalkSteppable";
}


std::string SwitchTipStalkSteppable::steerableName(){
   return toString();
}


